/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.sizeof;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SizeOf {
    private static Log _logger = LogFactory.getLog(SizeOf.class);
    private static Instrumentation inst;
    private static long MIN_CLASS_SIZE_TO_LOG;
    private static boolean SKIP_STATIC_FIELD;
    private static boolean SKIP_FINAL_FIELD;
    private static boolean SKIP_FLYWEIGHT_FIELD;
    private static boolean debug;
    private static String[] unit;

    public static void premain(String string, Instrumentation instrumentation) {
        inst = instrumentation;
        if (_logger.isTraceEnabled()) {
            _logger.debug((Object)"JAVAAGENT: called premain instrumentation for class SizeOf");
        }
    }

    public static long sizeOf(Object object) {
        if (inst == null) {
            throw new IllegalStateException("Instrumentation is null");
        }
        if (SKIP_FLYWEIGHT_FIELD && SizeOf.isSharedFlyweight(object)) {
            return 0L;
        }
        return inst.getObjectSize(object);
    }

    public static String humanReadable(long l) {
        int n;
        double d = l;
        for (n = 0; n < 4 && !(d < 1024.0); d /= 1024.0, ++n) {
        }
        return d + unit[n];
    }

    public static long deepSizeOf(Object object) {
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        return SizeOf.deepSizeOf(object, identityHashMap, 0);
    }

    public static long iterativeSizeOf(Object object) throws IllegalArgumentException, IllegalAccessException, IOException {
        return SizeOf.deepSizeOf(object);
    }

    private static String indent(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        return stringBuilder.toString();
    }

    private static long deepSizeOf(Object object, Map<Object, Object> map, int n) {
        if (object == null) {
            if (debug) {
                SizeOf.print("null");
            }
            return 0L;
        }
        long l = 0L;
        if (map.containsKey(object)) {
            if (debug) {
                SizeOf.print("%s{ yet computed }", SizeOf.indent(n));
            }
            return 0L;
        }
        if (debug) {
            SizeOf.print("%s{ %s", SizeOf.indent(n), object.getClass().getName());
        }
        map.put(object, null);
        l = SizeOf.sizeOf(object);
        if (object instanceof Object[]) {
            int n2 = 0;
            for (Object object2 : (Object[])object) {
                if (debug) {
                    SizeOf.print("%s [%d] = ", SizeOf.indent(n), n2++);
                }
                l += SizeOf.deepSizeOf(object2, map, n + 1);
            }
        } else {
            Field[] fieldArray;
            for (Field field : fieldArray = object.getClass().getDeclaredFields()) {
                Object object3;
                field.setAccessible(true);
                try {
                    object3 = field.get(object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                if (SizeOf.isComputable(field)) {
                    if (debug) {
                        SizeOf.print("%s %s = ", SizeOf.indent(n), field.getName());
                    }
                    l += SizeOf.deepSizeOf(object3, map, n + 1);
                    continue;
                }
                if (!debug) continue;
                SizeOf.print("%s %s = %s", SizeOf.indent(n), field.getName(), object3.toString());
            }
        }
        if (debug) {
            SizeOf.print("%s} size = %s", SizeOf.indent(n), SizeOf.humanReadable(l));
        }
        if (_logger.isDebugEnabled() && MIN_CLASS_SIZE_TO_LOG > 0L && l >= MIN_CLASS_SIZE_TO_LOG) {
            SizeOf.print("found big object: %s%s@%s size: %s", SizeOf.indent(n), object.getClass().getName(), System.identityHashCode(object), SizeOf.humanReadable(l));
        }
        return l;
    }

    private static boolean isAPrimitiveType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return true;
        }
        if (clazz == Character.TYPE) {
            return true;
        }
        if (clazz == Byte.TYPE) {
            return true;
        }
        if (clazz == Short.TYPE) {
            return true;
        }
        if (clazz == Integer.TYPE) {
            return true;
        }
        if (clazz == Long.TYPE) {
            return true;
        }
        if (clazz == Float.TYPE) {
            return true;
        }
        if (clazz == Double.TYPE) {
            return true;
        }
        return clazz == Void.TYPE;
    }

    private static boolean isComputable(Field field) {
        int n = field.getModifiers();
        if (SizeOf.isAPrimitiveType(field.getType())) {
            return false;
        }
        if (SKIP_STATIC_FIELD && Modifier.isStatic(n)) {
            return false;
        }
        return !SKIP_FINAL_FIELD || !Modifier.isFinal(n);
    }

    private static boolean isSharedFlyweight(Object object) {
        if (object instanceof Comparable) {
            if (object instanceof Enum) {
                return true;
            }
            if (object instanceof String) {
                return object == ((String)object).intern();
            }
            if (object instanceof Boolean) {
                return object == Boolean.TRUE || object == Boolean.FALSE;
            }
            if (object instanceof Integer) {
                return object == Integer.valueOf((Integer)object);
            }
            if (object instanceof Short) {
                return object == Short.valueOf((Short)object);
            }
            if (object instanceof Byte) {
                return object == Byte.valueOf((Byte)object);
            }
            if (object instanceof Long) {
                return object == Long.valueOf((Long)object);
            }
            if (object instanceof Character) {
                return object == Character.valueOf(((Character)object).charValue());
            }
        }
        return false;
    }

    public static void setMinSizeToLog(long l) {
        MIN_CLASS_SIZE_TO_LOG = l;
    }

    public static void skipFinalField(boolean bl) {
        SKIP_FINAL_FIELD = bl;
    }

    public static void skipStaticField(boolean bl) {
        SKIP_STATIC_FIELD = bl;
    }

    public static void skipFlyweightObject(boolean bl) {
        SKIP_FLYWEIGHT_FIELD = bl;
    }

    private static void print(String string) {
        _logger.debug((Object)string);
    }

    private static void print(String string, Object ... objectArray) {
        _logger.debug((Object)String.format(string, objectArray));
    }

    public static void turnOnDebug() {
        debug = true;
    }

    public static void turnOffDebug() {
        debug = false;
    }

    static {
        MIN_CLASS_SIZE_TO_LOG = 0x100000L;
        SKIP_STATIC_FIELD = false;
        SKIP_FINAL_FIELD = false;
        SKIP_FLYWEIGHT_FIELD = false;
        debug = false;
        unit = new String[]{"b", "kb", "mb", "gb"};
    }
}

