<?php
namespace Aura\Intl;

use Yoast\PHPUnitPolyfills\TestCases\TestCase;

/**
 * Test class for Package.
 * Generated by PHPUnit on 2012-10-27 at 22:46:01.
 */
class PackageLocatorTest extends TestCase
{
    protected $packages;

    protected function set_up()
    {
        parent::set_up();
        $this->packages = new PackageLocator([
            'Vendor.Foo' => [
                'en_US' => function () {
                    return new \Aura\Intl\Package;
                },
            ],
        ]);
    }

    public function testGet()
    {
        // get once to create it the first time
        $first = $this->packages->get('Vendor.Foo', 'en_US');
        $this->assertInstanceOf('Aura\Intl\Package', $first);

        // get again to make sure it's the same object
        $again = $this->packages->get('Vendor.Foo', 'en_US');
        $this->assertSame($first, $again);

        // try for an unregistered package
        $this->expectException('Aura\Intl\Exception');
        $this->packages->get('Vendor.Bar', 'en_US');
    }
}
